﻿using System;
using System.Data;
using System.Reflection;
using System.Threading;
using VBECS.Services.Common.Timing;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.Log;
using IServer = gov.va.med.vbecs.Common.IServer;
using IServerInner = VBECS.Services.Common.Timing.IServer;

namespace gov.va.med.VBECS.ReportSchedulerServer
{
    internal class Server : IServer
    {
        /// <summary>
        /// Implements Simple Example for timing job
        /// </summary>
        
        public event EventHandler<ThreadExceptionEventArgs> FatalErrorOccured;

        // Inner server
        private IServerInner _server;
        // Logger
        private readonly ILogger _logger =
            LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);
        // Events Logger
        private readonly ILogger _eventsLogger =
            LogManager.Instance().LoggerLocator.GetLogger("SystemEvents");

        public void Start()
        {
            if (_server != null) return; // The server is already started

            // Read timeout from configuration
            var timeOut = (int) GlobalContext.Instance().AppSettingsReader.GetValue("TimeOut", typeof (int));
            // TODO: assign server using Spring.NET or Factory
            _server = new SynchronousServer(timeOut);
            _server.TimeoutElapsed += ServerOnTimeoutElapsed;
            _server.FatalErrorOccured += delegate(object sender, ThreadExceptionEventArgs args)
                {
                    // Report to caller is subscribed
                    if (FatalErrorOccured != null)
                        FatalErrorOccured(sender, args);
                };

            _server.Start();
            _logger.Debug("A server started");
        }

        private void ServerOnTimeoutElapsed(object sender, EventArgs eventArgs)
        {
            // Print any pending reports in the queue
            try
            {
                _logger.Debug("Get Scheduled Reports");
                //Retrieve all pending reports
                var dtReports = VbecsReport.GetScheduledReports(TaskStatus.NotStarted);
                _logger.Debug("Reports#: " + dtReports.Rows.Count);
                //
                //Now mark them as in progress, print them, and mark them as complete
                foreach (DataRow drReport in dtReports.Rows)
                {
                    _logger.Debug("Start Processing Report");
                    //Mark as "In Progress"
                    VbecsReport.UpdateScheduledReportStatus((Guid)drReport[VbecsTables.ScheduledReport.ScheduledReportGuid], TaskStatus.InProgress, (byte[])drReport[VbecsTables.ScheduledReport.RowVersion]);
                    //
                    var s = drReport[VbecsTables.ScheduledReport.ReportParameters].ToString();
                    //
                    System.Xml.XmlReader reader = new System.Xml.XmlTextReader(new System.IO.StringReader(s));
                    var ds = new DataSet();
                    ds.ReadXml(reader);
                    var dr = ds.Tables[0].Rows[0];
                    //
                    var reportName = dr["ReportName"].ToString();
                    //
                    LogonUser.LogonUserDivisionCode = dr[VbecsTables.VamcDivision.DivisionCode].ToString();
                    //
                    //Create report object and print
                    var rpt = (VbecsReport)(Activator.CreateInstance("VBECS.BOL", reportName).Unwrap());
                    rpt.LoadPropertiesFromDataRow(dr);
                    rpt.IsScheduled = true;
                    rpt.GenerateAndPrintReport();
                    //
                    //Retrieve updated row version, then mark as "Complete"
                    var dtUpdateReport = VbecsReport.GetScheduledReport((Guid)drReport[VbecsTables.ScheduledReport.ScheduledReportGuid]);
                    VbecsReport.UpdateScheduledReportStatus((Guid)drReport[VbecsTables.ScheduledReport.ScheduledReportGuid], TaskStatus.Completed, (byte[])dtUpdateReport.Rows[0][VbecsTables.ScheduledReport.RowVersion]);
                }
            }
            catch (Exception e)
            {
                //Log exception but continue to print any other reports in queue.
                _logger.Error(e.Message);
                _eventsLogger.Error(e.Message);
            }
        }

        public void Stop()
        {
            if (_server == null) return; // The server is not started
            _server.Stop();
            _server = null;
            _logger.Debug("A server stopped");
        }
    }
}

